/*
RF Probe by Glen Popiel - KW5GP 


 This program is free software: you can redistribute it and/or modify
 it under the terms of the version 3 GNU General Public License as
 published by the Free Software Foundation.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 

 */

#define Signal_Pin A0    // select the input pin for the RF sensor

int Signal_Strength = 0;  // variable to store the value coming from the sensor
int bars;

void setup() 
{
  for (int x=2; x<=11; x++)  // Set pins 2-11 as LED Outputs
  {
    pinMode(x, OUTPUT);
  }
}

void loop() 
{
  // read the value from the sensor:
  Signal_Strength = analogRead(Signal_Pin); // Read the Signal Strength from the RF Sensor

  // Figure out how many bars to light
  bars = map(Signal_Strength,0,750,1,10);  // Map the Signal Strength to number of bars (1 to 10) One is always on to indicate power
  for (int x = 1; x<=bars; x++)  // Turn on all bars up to the mapped bar
  {
    digitalWrite(x+1, HIGH);  // Turn on the LED's
  }
  if (bars < 10)
  {
    for (int y = bars + 1; y<=10; y++)  // Make sure the rest of the bars are off
    {
      digitalWrite(y+1, LOW);  // Turn off the LED's
    }
  }
}


